/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.TerminalLineEvent;
import apiipc.generated.events.TerminalLineEventListener;
import apiipc.generated.sim.TerminalLine;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalLineEventRegistry
extends IPCEventRegistry {
    protected Set<TerminalLineEventListener> globalListeners = new HashSet<TerminalLineEventListener>();
    protected Map<String, Set<TerminalLineEventListener>> specificObjectListeners = new HashMap<String, Set<TerminalLineEventListener>>();

    public TerminalLineEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "TerminalLine";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        TerminalLineEvent terminalLineEvent = null;
        if (string.equalsIgnoreCase("terminalUpdated")) {
            terminalLineEvent = new TerminalLineEvent.TerminalUpdated(iPCEventLTV);
        } else if (string.equalsIgnoreCase("outputWritten")) {
            terminalLineEvent = new TerminalLineEvent.OutputWritten(iPCEventLTV);
        } else if (string.equalsIgnoreCase("cursorPositionChanged")) {
            terminalLineEvent = new TerminalLineEvent.CursorPositionChanged(iPCEventLTV);
        } else if (string.equalsIgnoreCase("directiveSent")) {
            terminalLineEvent = new TerminalLineEvent.DirectiveSent(iPCEventLTV);
        } else if (string.equalsIgnoreCase("commandStarted")) {
            terminalLineEvent = new TerminalLineEvent.CommandStarted(iPCEventLTV);
        } else if (string.equalsIgnoreCase("commandEnded")) {
            terminalLineEvent = new TerminalLineEvent.CommandEnded(iPCEventLTV);
        } else if (string.equalsIgnoreCase("commandAutoCompleted")) {
            terminalLineEvent = new TerminalLineEvent.CommandAutoCompleted(iPCEventLTV);
        } else if (string.equalsIgnoreCase("modeChanged")) {
            terminalLineEvent = new TerminalLineEvent.ModeChanged(iPCEventLTV);
        } else if (string.equalsIgnoreCase("promptChanged")) {
            terminalLineEvent = new TerminalLineEvent.PromptChanged(iPCEventLTV);
        } else if (string.equalsIgnoreCase("commandSelectedFromHistory")) {
            terminalLineEvent = new TerminalLineEvent.CommandSelectedFromHistory(iPCEventLTV);
        } else {
            return;
        }
        for (TerminalLineEventListener object : this.globalListeners) {
            object.handleEvent(terminalLineEvent);
        }
        Set<TerminalLineEventListener> set = this.specificObjectListeners.get(terminalLineEvent.objectUUID.toString());
        if (set != null) {
            for (TerminalLineEventListener terminalLineEventListener : set) {
                terminalLineEventListener.handleEvent(terminalLineEvent);
            }
        }
    }

    public void addListenerFiltered(TerminalLineEventListener terminalLineEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("terminalUpdated");
                this.register("outputWritten");
                this.register("cursorPositionChanged");
                this.register("directiveSent");
                this.register("commandStarted");
                this.register("commandEnded");
                this.register("commandAutoCompleted");
                this.register("modeChanged");
                this.register("promptChanged");
                this.register("commandSelectedFromHistory");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(terminalLineEventListener);
    }

    public void addSpecificListenerFiltered(TerminalLineEventListener terminalLineEventListener, TerminalLine terminalLine, List<String> list) throws IOException {
        UUID uUID = terminalLine.getObjectUUID();
        String string = uUID.toString();
        Set<TerminalLineEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<TerminalLineEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "terminalUpdated");
                this.register(uUID, "outputWritten");
                this.register(uUID, "cursorPositionChanged");
                this.register(uUID, "directiveSent");
                this.register(uUID, "commandStarted");
                this.register(uUID, "commandEnded");
                this.register(uUID, "commandAutoCompleted");
                this.register(uUID, "modeChanged");
                this.register(uUID, "promptChanged");
                this.register(uUID, "commandSelectedFromHistory");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(terminalLineEventListener);
    }

    public void removeListenerFiltered(TerminalLineEventListener terminalLineEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("terminalUpdated");
                this.deregister("outputWritten");
                this.deregister("cursorPositionChanged");
                this.deregister("directiveSent");
                this.deregister("commandStarted");
                this.deregister("commandEnded");
                this.deregister("commandAutoCompleted");
                this.deregister("modeChanged");
                this.deregister("promptChanged");
                this.deregister("commandSelectedFromHistory");
            }
            this.globalListeners.remove(terminalLineEventListener);
        }
    }

    public void removeSpecificListenerFiltered(TerminalLineEventListener terminalLineEventListener, TerminalLine terminalLine, List<String> list) throws IOException {
        UUID uUID = terminalLine.getObjectUUID();
        String string = uUID.toString();
        Set<TerminalLineEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "terminalUpdated");
            this.deregister(uUID, "outputWritten");
            this.deregister(uUID, "cursorPositionChanged");
            this.deregister(uUID, "directiveSent");
            this.deregister(uUID, "commandStarted");
            this.deregister(uUID, "commandEnded");
            this.deregister(uUID, "commandAutoCompleted");
            this.deregister(uUID, "modeChanged");
            this.deregister(uUID, "promptChanged");
            this.deregister(uUID, "commandSelectedFromHistory");
            set.remove(terminalLineEventListener);
        }
    }

    public void addListener(TerminalLineEventListener terminalLineEventListener) throws IOException {
        this.addListenerFiltered(terminalLineEventListener, null);
    }

    public void addListener(TerminalLineEventListener terminalLineEventListener, TerminalLine terminalLine) throws IOException {
        this.addSpecificListenerFiltered(terminalLineEventListener, terminalLine, null);
    }

    public void removeListener(TerminalLineEventListener terminalLineEventListener) throws IOException {
        this.removeListenerFiltered(terminalLineEventListener, null);
    }

    public void removeListener(TerminalLineEventListener terminalLineEventListener, TerminalLine terminalLine) throws IOException {
        this.removeSpecificListenerFiltered(terminalLineEventListener, terminalLine, null);
    }
}

